﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace GdiPlusDemo
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
    protected override void OnPaint(PaintEventArgs e)
        {
            var pen = new Pen(Color.LavenderBlush, 5);
            var brush = new SolidBrush(Color.Goldenrod);

            e.Graphics.FillRectangle(brush, ClientRectangle);
            e.Graphics.DrawRectangle(
                pen,
                ClientRectangle.X + 20,
                ClientRectangle.Y + 20,
                ClientRectangle.Width - 40,
                ClientRectangle.Height - 40);
            var textPos = new PointF(
                ClientRectangle.X + 25,
                ClientRectangle.Y + 25);

            (from fontFamily in FontFamily.Families
             select fontFamily)
             .Skip(15)
             .Take(9)
             .ToList()
             .ForEach(
                fontFamily =>
                {
                    var currFont = new Font(fontFamily, 15);

                    e.Graphics.DrawString(
                        fontFamily.Name,
                        currFont,
                        Brushes.DarkOrchid,
                        textPos);

                    textPos.Y += currFont.Height;
                });
        base.OnPaint(e);
        }

    }
}
